
String.prototype.format = function () {
  let args = Array.prototype.slice.call(arguments);

  if (args.length === 0 || args[0] == null) {
    return this;
  }

  if (args.length === 1 && typeof args[0] === 'object' && !Array.isArray(args[0])) {
    // Wenn ein einzelnes Objekt übergeben wird
    let obj = args[0];
    return this.replace(/\{([^}]+)\}/g, function (match, key) {
      return typeof obj[key] != 'undefined' ? obj[key] : match;
    });
  } else {
    // Wenn mehrere Argumente oder ein Array übergeben werden
    if (args.length === 1 && Array.isArray(args[0])) {
      args = args[0];
    }
    return this.replace(/\{(\d+)\}/g, function (match, number) {
      return typeof args[number] != 'undefined' ? args[number] : match;
    });
  }
};

String.prototype.isUUID = function () {
  let exp = '^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$';
  return new RegExp(exp).test(this);
};

String.prototype.escapeRegExp = function () {
  return this.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'); // $& means the whole matched string
};

String.prototype.unbracket = function () {
  let s = this.trim();
  let first = s.substring(0, 1);
  let last;
  switch (first) {
    case '[':
      first = '\\[';
      last = '\\]';
      break;
    case '{':
      first = '\\{';
      last = '\\}';
      break;
    case '(':
      first = '\\(';
      last = '\\)';
      break;
    case '<':
      first = '\\<';
      last = '\\>';
      break;
    case '"':
      first = '\\"';
      last = '\\"';
      break;
    case '\'':
      first = '\\\'';
      last = '\\\'';
      break;
    case '/':
      first = '\\/';
      last = '\\/';
      break;
  }
  if (last) {
    let re = new RegExp('^' + first + '(.*)' + last + '$');
    return s.replace(re, '$1');
  }
  return s;
};

String.prototype.unquote = function () {
  return this.unbracket();
};

String.prototype.quote = function (q) {
  let s = this.trim();
  let first = s.substring(0, 1);
  let last;
  switch (q) {
    case '[':
      first = '[';
      last = ']';
      break;
    case '{':
      first = '{';
      last = '}';
      break;
    case '(':
      first = '(';
      last = ')';
      break;
    case '<':
      first = '<';
      last = '>';
      break;
    case '"':
      first = '"';
      last = '"';
      break;
    case '\'':
      first = '\'';
      last = '\'';
      break;
    case '/':
      first = '/';
      last = '/';
      break;
    default:
      first = '"';
      last = '"';
      break;
  }
  return first + this + last;
};

String.prototype.bracket = function (q) {
  return this.quote(q);
};

String.prototype.replaceAll = function (a, b) {
  return this.replace(new RegExp(a, 'g'), b);
};

String.prototype.contains = function (a) {
  return this.indexOf(a) >= 0;
};

if (!String.prototype.padStart) {
  String.prototype.padStart = function padStart(targetLength, padString) {
    targetLength = targetLength >> 0; // Truncate if decimal and convert to integer
    padString = String(typeof padString !== 'undefined' ? padString : ' ');

    if (this.length > targetLength) {
      return String(this);
    } else {
      targetLength = targetLength - this.length;

      if (targetLength > padString.length) {
        // Append to original to ensure we are longer than needed
        padString += padString.repeat(targetLength / padString.length);
      }

      return padString.slice(0, targetLength) + String(this);
    }
  };
}

/**
String.prototype.startsWith = function(str) {
  return this.slice(0, str.length) === str;
};

String.prototype.endsWith = function(str) {
  return this.slice(this.length - str.length, this.length) === str;
};
/**/

/**
  Object.defineProperty(Object.prototype, 'methodOnSteriods',{
  value: function(){ },
  writable: true,
  configurable: true,
  enumerable: false
});

**/
